/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.model;

import com.aptana.core.ShellExecutable;
import com.aptana.core.util.SourcePrinter;
import com.aptana.scripting.ScriptLogger;
import com.aptana.scripting.ScriptUtils;
import com.aptana.scripting.ScriptingActivator;
import com.aptana.scripting.ScriptingEngine;
import com.aptana.scripting.model.AbstractBundleElement;
import com.aptana.scripting.model.AbstractCommandRunner;
import com.aptana.scripting.model.BundleElement;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.CommandBlockRunner;
import com.aptana.scripting.model.CommandContext;
import com.aptana.scripting.model.CommandResult;
import com.aptana.scripting.model.CommandScriptRunner;
import com.aptana.scripting.model.EnvironmentContributor;
import com.aptana.scripting.model.InputType;
import com.aptana.scripting.model.Messages;
import com.aptana.scripting.model.OutputType;
import com.aptana.scripting.model.Platform;
import com.aptana.scripting.model.RunType;
import com.aptana.scripting.model.TriggerType;
import com.aptana.scripting.model.WorkingDirectoryType;
import java.io.ByteArrayOutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyProc;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandElement
extends AbstractBundleElement {
    private static final InvokeUnion NO_INVOKE = new InvokeUnion(){

        public String getInvoke() {
            return null;
        }

        public RubyProc getInvokeBlock() {
            return null;
        }

        public String toString() {
            return "";
        }
    };
    private static final InputType[] NO_TYPES = new InputType[0];
    private static final String[] NO_KEY_BINDINGS = new String[0];
    private static final String[] NO_TRIGGER_VALUES = new String[0];
    private static final String TO_ENV_METHOD_NAME = "to_env";
    private Map<Platform, InvokeUnion> _invokeUnionMap;
    private Map<Platform, List<String>> _keyBindings;
    private InputType[] _inputTypes = NO_TYPES;
    private String _inputPath;
    private OutputType _outputType = OutputType.UNDEFINED;
    private String _outputPath;
    private boolean _async;
    private RunType _runType;
    private Ruby _runtime;
    private IPath _workingDirectoryPath;
    private WorkingDirectoryType _workingDirectoryType = WorkingDirectoryType.UNDEFINED;

    public CommandElement(String path) {
        super(path);
        this._runType = ScriptingActivator.getDefaultRunType();
    }

    public CommandContext createCommandContext() {
        return new CommandContext(this);
    }

    public CommandResult execute() {
        return this.execute(this.createCommandContext());
    }

    public CommandResult execute(CommandContext context) {
        CommandResult result = null;
        if (this.isExecutable()) {
            AbstractCommandRunner job = null;
            boolean async = this._async && this._outputType.allowAsync();
            context.setOutputType(this._outputType);
            if (this.isShellCommand()) {
                job = new CommandScriptRunner(this, context);
            } else if (this.isBlockCommand()) {
                context.setOutputStream(new ByteArrayOutputStream());
                BundleElement bundle = this.getOwningBundle();
                String bundleName = bundle.getDisplayName();
                job = new CommandBlockRunner(this, context, BundleManager.getInstance().getBundleLoadPaths(bundleName));
            }
            if (job != null) {
                try {
                    job.run("Execute '" + this.getDisplayName() + "'", this._runType, async);
                }
                catch (InterruptedException e) {
                    String message = MessageFormat.format(Messages.CommandElement_Error_Executing_Command, this.getDisplayName(), this.getPath());
                    ScriptUtils.logErrorWithStackTrace(message, e);
                }
                CommandResult commandResult = result = async && this._runType != RunType.CURRENT_THREAD ? new CommandResult(this, context) : job.getCommandResult();
            }
        }
        if (result != null) {
            String inputTypeString = (String)context.get("input_type");
            InputType inputType = InputType.get(inputTypeString);
            result.setInputType(inputType);
        }
        return result;
    }

    @Override
    protected String getElementName() {
        return "command";
    }

    public String getInputPath() {
        return this._inputPath;
    }

    public InputType[] getInputTypes() {
        return this._inputTypes;
    }

    public List<String> getInput() {
        if (this.getInputTypes() == null) {
            return null;
        }
        ArrayList<String> inputs = new ArrayList<String>();
        InputType[] inputTypeArray = this.getInputTypes();
        int n = inputTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            InputType it = inputTypeArray[n2];
            inputs.add(it.getName());
            ++n2;
        }
        return inputs;
    }

    public void setInput(List<String> inputs) {
        this.setInputType(inputs.toArray(new String[inputs.size()]));
    }

    private InvokeUnion getInvokeUnion() {
        Platform[] platforms = Platform.getCurrentPlatforms();
        InvokeUnion result = null;
        if (this._invokeUnionMap == null) {
            return NO_INVOKE;
        }
        Platform[] platformArray = platforms;
        int n = platforms.length;
        int n2 = 0;
        while (n2 < n) {
            Platform platform = platformArray[n2];
            if (platform != Platform.UNDEFINED && (result = this._invokeUnionMap.get((Object)platform)) != null) break;
            ++n2;
        }
        if (result == null) {
            result = this._invokeUnionMap.get((Object)Platform.ALL);
        }
        if (result == null) {
            result = NO_INVOKE;
        }
        return result;
    }

    private void setInvokeUnion(String OS, InvokeUnion invokeUnion) {
        Platform bindingOS = Platform.get(OS);
        if (bindingOS != Platform.UNDEFINED) {
            if (this._invokeUnionMap == null) {
                this._invokeUnionMap = new HashMap<Platform, InvokeUnion>(1);
            }
            this._invokeUnionMap.put(bindingOS, invokeUnion);
        } else {
            String message = MessageFormat.format(Messages.CommandElement_Unrecognized_OS, this.getPath(), OS);
            ScriptLogger.logWarning(message);
        }
    }

    public String getInvoke() {
        return this.getInvokeUnion().getInvoke();
    }

    public RubyProc getInvokeBlock() {
        return this.getInvokeUnion().getInvokeBlock();
    }

    public String[] getKeyBindings() {
        Platform[] platforms = Platform.getCurrentPlatforms();
        List<String> result = null;
        if (this._keyBindings == null) {
            return NO_KEY_BINDINGS;
        }
        Platform[] platformArray = platforms;
        int n = platforms.length;
        int n2 = 0;
        while (n2 < n) {
            Platform platform = platformArray[n2];
            if (platform != Platform.UNDEFINED && (result = this._keyBindings.get((Object)platform)) != null && result.size() > 0) break;
            ++n2;
        }
        if (result == null) {
            result = this._keyBindings.get((Object)Platform.ALL);
        }
        return result.toArray(new String[result.size()]);
    }

    public Map<Platform, List<String>> getKeyBindingMap() {
        return this._keyBindings;
    }

    public void setKeyBindingMap(Map<Platform, List<String>> keybindingMap) {
        if (keybindingMap != null) {
            for (Map.Entry<Platform, List<String>> entry : keybindingMap.entrySet()) {
                this.setKeyBindings(entry.getKey().getName(), entry.getValue().toArray(new String[entry.getValue().size()]));
            }
        }
    }

    public String getOutputPath() {
        return this._outputPath;
    }

    public String getOutputType() {
        return this._outputType.getName();
    }

    public Ruby getRuntime() {
        return this._runtime;
    }

    public String getRunType() {
        return this._runType.getName();
    }

    public String[] getTriggerTypeValues(TriggerType type) {
        String[] result = NO_TRIGGER_VALUES;
        if (type != null && type != TriggerType.UNDEFINED) {
            String propertyName = type.getPropertyName();
            Object value = this.get(propertyName);
            if (value instanceof String[]) {
                result = (String[])value;
            } else if (value instanceof Object[]) {
                Object[] objects = (Object[])value;
                result = new String[objects.length];
                int i = 0;
                while (i < objects.length) {
                    result[i] = objects[i].toString();
                    ++i;
                }
            } else if (value != null) {
                result = new String[]{value.toString()};
            }
        }
        return result;
    }

    public IPath getWorkingDirectory() {
        switch (this._workingDirectoryType) {
            case PATH: 
            case CURRENT_PROJECT: {
                return this._workingDirectoryPath;
            }
            case CURRENT_BUNDLE: {
                return Path.fromOSString((String)this.getOwningBundle().getBundleDirectory().getAbsolutePath());
            }
        }
        return Path.fromOSString((String)this.getPath()).removeLastSegments(1);
    }

    public WorkingDirectoryType getWorkingDirectoryType() {
        return this._workingDirectoryType;
    }

    public boolean isAsync() {
        return this._async;
    }

    public boolean isBlockCommand() {
        return this.getInvokeUnion().getInvokeBlock() != null;
    }

    public boolean isExecutable() {
        return this.getInvoke() != null && this.getInvoke().length() > 0 || this.getInvokeBlock() != null;
    }

    public boolean isShellCommand() {
        return this.getInvokeBlock() == null && this.getInvoke() != null && this.getInvoke().length() > 0;
    }

    void populateEnvironment(Map<String, Object> contextMap, Map<String, String> environment) {
        environment.putAll(ShellExecutable.getEnvironment());
        if ("win32".equals(org.eclipse.core.runtime.Platform.getOS())) {
            environment.remove("PATH");
            environment.remove("PWD");
            String path = System.getenv("Path");
            environment.put("PATH", path);
        }
        for (Map.Entry<String, Object> entry : contextMap.entrySet()) {
            Object valueObject = entry.getValue();
            String key = entry.getKey().toUpperCase();
            if (valueObject instanceof IRubyObject) {
                IRubyObject rubyObject = (IRubyObject)valueObject;
                if (!rubyObject.respondsTo(TO_ENV_METHOD_NAME)) continue;
                Ruby runtime = ScriptingEngine.getInstance().getInitializedScriptingContainer().getProvider().getRuntime();
                ThreadContext threadContext = runtime.getCurrentContext();
                try {
                    IRubyObject methodResult = rubyObject.callMethod(threadContext, TO_ENV_METHOD_NAME);
                    if (!(methodResult instanceof RubyHash)) continue;
                    RubyHash environmentHash = (RubyHash)methodResult;
                    for (Object hashKey : environmentHash.keySet()) {
                        environment.put(hashKey.toString(), environmentHash.get(hashKey).toString());
                    }
                }
                catch (RaiseException e) {
                    String message = MessageFormat.format(Messages.CommandElement_Error_Building_Env_Variables, entry.getKey(), this.getDisplayName(), this.getPath(), e.getMessage());
                    ScriptLogger.logError(message);
                    e.printStackTrace();
                }
                continue;
            }
            if (valueObject instanceof EnvironmentContributor) {
                EnvironmentContributor contributor = (EnvironmentContributor)valueObject;
                Map<String, String> contributedEnvironment = contributor.toEnvironment();
                if (contributedEnvironment == null) continue;
                environment.putAll(contributedEnvironment);
                continue;
            }
            if (valueObject == null) continue;
            environment.put(key, valueObject.toString());
        }
    }

    @Override
    protected void printBody(SourcePrinter printer, boolean includeBlocks) {
        InputType[] types;
        printer.printWithIndent("name: ").println(this.getDisplayName());
        printer.printWithIndent("path: ").println(this.getPath());
        printer.printWithIndent("scope: ").println(this.getScope());
        if (includeBlocks && this.getInvoke() != null) {
            printer.printWithIndent("invoke: ").println(this.getInvoke());
        }
        if (includeBlocks && this.getInvokeBlock() != null) {
            printer.printWithIndent("block: ").println(this.getInvokeBlock().getBlock().type.toString());
        }
        if (this._keyBindings != null && this._keyBindings.size() > 0) {
            printer.printlnWithIndent("keys {").increaseIndent();
            for (Map.Entry<Platform, List<String>> entry : this._keyBindings.entrySet()) {
                printer.printWithIndent(entry.getKey().getName()).print(": ");
                boolean first = true;
                for (String binding : entry.getValue()) {
                    if (!first) {
                        printer.print(", ");
                    }
                    printer.print(binding);
                    first = false;
                }
                printer.println();
            }
            printer.decreaseIndent().printlnWithIndent("}");
        }
        if ((types = this.getInputTypes()) != null && types.length > 0) {
            boolean first = true;
            printer.printWithIndent("input: ");
            InputType[] inputTypeArray = types;
            int n = types.length;
            int binding = 0;
            while (binding < n) {
                InputType type = inputTypeArray[binding];
                if (!first) {
                    printer.print(", ");
                }
                printer.print(type.getName());
                first = false;
                ++binding;
            }
            printer.println();
        }
        printer.printWithIndent("output: ").println(this.getOutputType());
        String[] triggers = this.getTriggerTypeValues(TriggerType.PREFIX);
        if (triggers != null && triggers.length > 0) {
            boolean first = true;
            printer.printWithIndent("triggers: ");
            String[] stringArray = triggers;
            int n = triggers.length;
            int n2 = 0;
            while (n2 < n) {
                String trigger = stringArray[n2];
                if (!first) {
                    printer.print(", ");
                }
                printer.print(trigger);
                first = false;
                ++n2;
            }
            printer.println();
        }
    }

    public void setAsync(boolean value) {
        this._async = value;
    }

    public void setInputPath(String path) {
        this._inputPath = path;
    }

    public void setInputType(InputType type) {
        this.setInputType(new InputType[]{type});
    }

    public void setInputType(InputType[] types) {
        this._inputTypes = types == null ? NO_TYPES : types;
    }

    public void setInputType(String input) {
        this.setInputType(InputType.get(input));
    }

    public void setInputType(String[] types) {
        InputType[] result = null;
        if (types != null) {
            result = new InputType[types.length];
            int i = 0;
            while (i < types.length) {
                result[i] = InputType.get(types[i]);
                ++i;
            }
        }
        this.setInputType(result);
    }

    public void setInvoke(String invoke) {
        this.setInvoke(Platform.ALL.getName(), invoke);
    }

    public void setInvokeBlock(RubyProc block) {
        this.setInvokeBlock(Platform.ALL.getName(), block);
    }

    public void setInvoke(String OS, String invoke) {
        Invoke invokeUnion = new Invoke(invoke);
        this.setInvokeUnion(OS, invokeUnion);
    }

    public void setInvokeBlock(String OS, RubyProc block) {
        InvokeBlock invokeUnion = new InvokeBlock(block);
        this.setInvokeUnion(OS, invokeUnion);
        this.setRuntime(block != null ? block.getRuntime() : null);
    }

    public void setKeyBinding(String OS, String keyBinding) {
        if (keyBinding != null && keyBinding.length() > 0) {
            this.setKeyBindings(OS, new String[]{keyBinding});
        } else {
            String message = MessageFormat.format(Messages.CommandElement_Undefined_Key_Binding, this.getPath());
            ScriptLogger.logWarning(message);
        }
    }

    public void setKeyBindings(String OS, String[] keyBindings) {
        Platform bindingOS = Platform.get(OS);
        if (bindingOS != Platform.UNDEFINED) {
            if (this._keyBindings == null) {
                this._keyBindings = new HashMap<Platform, List<String>>(1);
            }
            ArrayList<String> uppercase = new ArrayList<String>(keyBindings.length);
            String[] stringArray = keyBindings;
            int n = keyBindings.length;
            int n2 = 0;
            while (n2 < n) {
                String binding = stringArray[n2];
                uppercase.add(binding.toUpperCase());
                ++n2;
            }
            this._keyBindings.put(bindingOS, uppercase);
        } else {
            String message = MessageFormat.format(Messages.CommandElement_Unrecognized_OS, this.getPath(), OS);
            ScriptLogger.logWarning(message);
        }
    }

    public void setOutputPath(String path) {
        this._outputPath = path;
    }

    public void setOutputType(OutputType type) {
        this._outputType = type;
    }

    public void setOutputType(String output) {
        this._outputType = OutputType.get(output);
    }

    public void setRunType(String type) {
        this._runType = RunType.get(type);
    }

    public void setRuntime(IRubyObject object) {
        this.setRuntime(object != null ? object.getRuntime() : null);
    }

    public void setRuntime(Ruby runtime) {
        this._runtime = runtime;
    }

    public void setRunType(RunType type) {
        this._runType = type;
    }

    public void setTrigger(String type) {
        this.setTrigger(type, NO_TRIGGER_VALUES);
    }

    public void setTrigger(String type, String[] values) {
        TriggerType triggerType = TriggerType.get(type);
        if (triggerType != TriggerType.UNDEFINED && values != null) {
            String propertyName = triggerType.getPropertyName();
            this.put(propertyName, values);
        }
    }

    public void setWorkingDirectoryPath(IPath path) {
        this._workingDirectoryPath = path;
    }

    public void setWorkingDirectoryType(String workingDirectory) {
        this._workingDirectoryType = WorkingDirectoryType.get(workingDirectory);
    }

    public void setWorkingDirectoryType(WorkingDirectoryType type) {
        this._workingDirectoryType = type;
    }

    public Map<String, String> getEnvironment() {
        CommandContext commandContext = this.createCommandContext();
        LinkedHashMap<String, String> environment = new LinkedHashMap<String, String>(new ProcessBuilder(new String[0]).environment());
        this.populateEnvironment(commandContext.getMap(), environment);
        return environment;
    }

    private static final class Invoke
    implements InvokeUnion {
        private final String _invoke;

        private Invoke(String invoke) {
            this._invoke = invoke;
        }

        public String getInvoke() {
            return this._invoke;
        }

        public RubyProc getInvokeBlock() {
            return null;
        }

        public String toString() {
            return "invoke= " + this._invoke;
        }
    }

    private static final class InvokeBlock
    implements InvokeUnion {
        private final RubyProc _invokeBlock;

        private InvokeBlock(RubyProc invokeBlock) {
            this._invokeBlock = invokeBlock;
        }

        public String getInvoke() {
            return null;
        }

        public RubyProc getInvokeBlock() {
            return this._invokeBlock;
        }

        public String toString() {
            return "invoke <block>";
        }
    }

    private static interface InvokeUnion {
        public String getInvoke();

        public RubyProc getInvokeBlock();
    }
}

